﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using System.Drawing;
using static Spectral1.DATA_ACCESS.DA_3DWireframe;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class c_waveform_set
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;

        private Int32 _waveform_set_id;
        private Int32 _current_note_sector_id = 0;
        private Int32 _current_intensity_layer_id = 0;
        public c_block[,] block = new c_block[DA_Spectral.max_note_sectors, DA_Spectral.max_intensity_layers];

        #endregion

        #region "================ PROPERTIES ========================"

        public Int32 timbre_mode
        {
            get
            {
                return _CGS.Table_waveform_set.GetRow(waveform_set_id).timbre_mode;
            }
            set
            {
                _CGS.Table_waveform_set.GetRow(waveform_set_id).timbre_mode = value;
            }

        }

        public string waveform_set_name
        {
            get
            {
                return _CGS.Table_waveform_set.GetRow(waveform_set_id).waveform_set_name;
            }
            set
            {
                _CGS.Table_waveform_set.GetRow(waveform_set_id).waveform_set_name = value;
            }
        }

        public Int32 current_note_sector_id
        {
            get
            {
                return _current_note_sector_id;
            }
            set
            {
                _current_note_sector_id = value;
                _CGS.Table_waveform.SetDefaultViewFilter("waveform_set_id = " + _CGS.Table_waveform_set.CurrentRow.waveform_set_id.ToString() + " AND note_sector_id = " + _current_note_sector_id.ToString() + " AND intensity_layer_id = " + _current_intensity_layer_id.ToString());
            }
        }

        public Int32 current_intensity_layer_id
        {
            get
            {
                return _current_intensity_layer_id;
            }
            set
            {
                _current_intensity_layer_id = value;
                _CGS.Table_waveform.SetDefaultViewFilter("waveform_set_id = " + _CGS.Table_waveform_set.CurrentRow.waveform_set_id.ToString() + " AND note_sector_id = " + _current_note_sector_id.ToString() + " AND intensity_layer_id = " + _current_intensity_layer_id.ToString());
            }
        }

        private waveform_setRow r
        {
            get
            {
                return _CGS.Table_waveform_set.GetRow(waveform_set_id);
            }
        }

        public c_block current_block
        {
            get
            {
                return block[current_note_sector_id, current_intensity_layer_id];
            }
        }

        public string name
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    return r.waveform_set_name;
                }
            }
            set
            {
                if (r != null)
                { r.waveform_set_name = value; }
            }
        }

        public DA_Spectral.used_midi_cc intensitycc
        {
            get
            {
                if (r == null)
                {
                    return DA_Spectral.used_midi_cc.ucc_none;
                }
                else
                {
                    return (DA_Spectral.used_midi_cc)r.intensity_controller_source;
                }
            }
            set
            {
                if (r != null)
                { r.intensity_controller_source = (Int32)value; }
            }
        }

        public DA_Spectral.used_midi_cc waveformcc
        {
            get
            {
                if (r == null)
                {
                    return DA_Spectral.used_midi_cc.ucc_none;
                }
                else
                {
                    return (DA_Spectral.used_midi_cc)r.waveform_controller_source;
                }
            }
            set
            {
                if (r != null)
                { r.waveform_controller_source = (Int32)value; }
            }
        }

        public string guid8
        {
            get
            {
                if (r == null)
                {
                    return "";
                }
                else
                {
                    return r.waveform_set_guid8;
                }
            }
            set
            {
                if (r != null)
                { r.waveform_set_guid8 = value; }
            }
        }

        public DA_Spectral.timbre_modes timbremode
        {
            get
            {
                if (r == null)
                {
                    return DA_Spectral.timbre_modes.timbre_envelope;
                }
                else
                {
                    return (DA_Spectral.timbre_modes)r.timbre_mode;
                }
            }
            set
            {
                if (r != null)
                { r.timbre_mode = (Int32)value; }
            }
        }

        public Int32 waveform_set_id { get { return _waveform_set_id; } }
        #endregion

        #region "================ METHODS - MORPH ==============="
        public string morph_harmonics_across_note_sectors(c_from_to_range morph_range,Int32 for_intensity_layer,Int32 for_waveform)
        {
            string error_text = "";

            double level_delta;
            Int32 level_min;
            Int32 level_max;
            Int32 il_min;
            Int32 il_max;
            Int32 w_min;
            Int32 w_max;

            if (for_waveform == -1)
            {
                w_min = 0;
                w_max = DA_Spectral.max_waveforms - 1;
            }
            else
            {
                w_min = for_waveform;
                w_max = for_waveform;
            }

            if (for_intensity_layer == -1)
            {
                il_min = 0;
                il_max = DA_Spectral.max_intensity_layers - 1;
            }
            else
            {
                il_min = for_intensity_layer;
                il_max = for_intensity_layer;
            }

            for (Int32 il = il_min; il <= il_max; il++)
            {
                for (Int32 n = morph_range.from_id; n <= morph_range.to_id; n++)
                {
                    for (Int32 w = w_min; w <= w_max; w++)
                    {
                        for (Int32 h = 0; h < max_harmonics; h++)
                        {
                            level_min = block[morph_range.from_id, il].waveform[w].get_harmonic_level(h);
                            level_max = block[morph_range.to_id, il].waveform[w].get_harmonic_level(h);
                            level_delta = (double)(level_max - level_min) / ((double)(morph_range.to_id - morph_range.from_id));

                            block[n, il].waveform[w].set_harmonic_level(h, (Int32)(level_min + (n - morph_range.from_id) * level_delta));
                        }
                    }
                }
            }

            return error_text;
        }

        public string morph_harmonics_across_intensity_layers(c_from_to_range morph_range,int for_note_sector,Int32 for_waveform)
        {
            string error_text = "";

            double level_delta;
            Int32 level_min;
            Int32 level_max;
            Int32 ns_min;
            Int32 ns_max;
            Int32 w_min;
            Int32 w_max;

            if (for_waveform == -1)
            {
                w_min = 0;
                w_max = DA_Spectral.max_waveforms - 1;
            }
            else
            {
                w_min = for_waveform;
                w_max = for_waveform;
            }

            if (for_note_sector == -1)
            {
                ns_min = 0;
                ns_max = DA_Spectral.max_note_sectors - 1;
            }
            else
            {
                ns_min = for_note_sector;
                ns_max = for_note_sector;
            }

            for (Int32 ns = ns_min; ns <= ns_max; ns++)
            {
                for (Int32 il = morph_range.from_id; il <= morph_range.to_id; il++)
                {
                    for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                    {
                        for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                        {
                            level_min = block[ns, morph_range.from_id].waveform[w].get_harmonic_level(h);
                            level_max = block[ns, morph_range.to_id].waveform[w].get_harmonic_level(h);
                            level_delta = (double)(level_max - level_min) / ((double)(morph_range.to_id - morph_range.from_id));

                            block[ns, il].waveform[w].set_harmonic_level(h, (Int32)(level_min + (il * level_delta)));

                        }
                    }
                }
            }

            return error_text;
        }


        #endregion

        #region "================ METHODS - OTHER =================="
        public c_waveform_set clone()
        {
            Int32 new_waveform_set_id = _CGS.Table_waveform_set.AddRow2(BL_Spectral.GetNewGuid8(), "COPY_" + _CGS.Table_waveform_set.CurrentRow.waveform_set_name, Convert.ToInt32(DA_Spectral.timbre_modes.timbre_envelope), Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none), Convert.ToInt32(DA_Spectral.used_midi_cc.ucc_none));
            c_waveform_set new_waveset = new c_waveform_set(_CGS, _DASP, new_waveform_set_id, current_note_sector_id, current_intensity_layer_id);

            for (Int32 ns = 0; ns < DA_Spectral.max_note_sectors; ns++)
            {
                for (Int32 il = 0; il < DA_Spectral.max_intensity_layers; il++)
                {
                    for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                    {
                        for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                        {
                            new_waveset.block[ns, il].waveform[w].set_harmonic_level(h, block[ns, il].waveform[w].get_harmonic_level(h));
                            new_waveset.block[ns, il].waveform[w].set_harmonic_phase(h, block[ns, il].waveform[w].get_harmonic_phase(h));
                        }
                        new_waveset.block[ns, il].waveform[w].description = block[ns, il].waveform[w].description;
                    }
                }
            }
            return new_waveset;
        }

        public void clear()
        {
            for (Int32 ns = 0; ns < DA_Spectral.max_note_sectors; ns++)
            {
                for (Int32 il = 0; il < DA_Spectral.max_intensity_layers; il++)
                {
                    block[ns, il].clear_harmonics();
                }
            }
        }

        #endregion


        #region "================ METHODS ========================"

        public c_waveform_set(CodeGen_DS_Spectral CGS, DA_Spectral DASP,Int32 ws, Int32 initial_note_sector_id, Int32 initial_intensity_layer_id)
        {
            _CGS = CGS;
            _DASP = DASP;
            _waveform_set_id = ws;
            current_note_sector_id = initial_note_sector_id;
            current_intensity_layer_id = initial_intensity_layer_id;
            for (Int32 s = 0; s < DA_Spectral.max_note_sectors; s++)
            {
                for (Int32 i = 0; i < DA_Spectral.max_intensity_layers; i++)
                {
                    block[s, i] = new c_block(_CGS,_DASP,ws, s, i);
                }
            }
            all_changed(true);//Added 271221
        }

        public void all_changed(bool value)
        {
            _DASP.data_changed.waveset.set_all(value);
        }

        public void copy_waveform_in_all_dimensions()
        {
            for (Int32 il = 0; il < DA_Spectral.max_intensity_layers; il++)
            {
                for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                {
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        for (Int32 ns = 0; ns < DA_Spectral.max_note_sectors; ns++)
                        {
                            block[ns, il].waveform[w].set_harmonic_level(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, current_note_sector_id, current_intensity_layer_id, current_block.current_waveform_id, h).level);
                            block[ns, il].waveform[w].set_harmonic_phase(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, current_note_sector_id, current_intensity_layer_id, current_block.current_waveform_id, h).phase_offset == 1);
                        }
                    }
                }
            }
        }

        public void copy_waveform_block_in_all_dimensions()
        {
            for (Int32 ns = 0; ns < DA_Spectral.max_note_sectors; ns++)
            {
                for (Int32 il = 0; il < DA_Spectral.max_intensity_layers; il++)
                {
                    for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                    {
                        current_block.copy_block_harmonics(block[ns, il]);
                    }
                }
            }
        }

        public string copy_note_sector_to(c_from_to_range copy_range, Int32 for_intensity_layer,Int32 for_waveform)
        {
            string error_text = "";
            Int32 il_from;
            Int32 il_to;
            if (for_intensity_layer != -1)
            {
                il_from = for_intensity_layer;
                il_to = for_intensity_layer;
            }
            else
            {
                il_from = 0;
                il_to = max_intensity_layers - 1;
            }

            Int32 w_from;
            Int32 w_to;
            if (for_waveform != -1)
            {
                w_from = for_waveform;
                w_to = for_waveform;
            }
            else
            {
                w_from = 0;
                w_to = max_waveforms - 1;
            }

            for (Int32 l = il_from; l <=il_to; l++)
            {
                for (Int32 w = w_from; w <= w_to; w++)
                {
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        for (Int32 n = copy_range.from_id; n <= copy_range.to_id; n++)
                        {
                            if (n != current_note_sector_id)
                            {
                                block[n, l].waveform[w].set_harmonic_level(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, current_note_sector_id, l, w, h).level);
                                block[n, l].waveform[w].set_harmonic_phase(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, current_note_sector_id, l, w, h).phase_offset == 1);
                            }
                        }
                    }
                }
            }
            return error_text;
        }

        public string copy_intensity_layer_to(c_from_to_range copy_range, Int32 for_note_sector,Int32 for_waveform)
        {
            string error_text = "";
            Int32 ns_from;
            Int32 ns_to;
            if (for_note_sector != -1)
            {
                ns_from = for_note_sector;
                ns_to = for_note_sector;
            }
            else
            {
                ns_from = 0;
                ns_to = max_note_sectors - 1;
            }

            Int32 w_from;
            Int32 w_to;
            if (for_waveform != -1)
            {
                w_from = for_waveform;
                w_to = for_waveform;
            }
            else
            {
                w_from = 0;
                w_to = max_waveforms - 1;
            }


            for (Int32 n = ns_from; n <= ns_to; n++)
            {
                for (Int32 w = w_from; w <= w_to; w++)
                {
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        for (Int32 l = copy_range.from_id; l <= copy_range.to_id; l++)
                        {
                            if (l != current_intensity_layer_id)
                            {
                                block[n, l].waveform[w].set_harmonic_level(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, n, current_intensity_layer_id, w, h).level);
                                block[n, l].waveform[w].set_harmonic_phase(h, _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, n, current_intensity_layer_id, w, h).phase_offset == 1);
                            }
                        }
                    }
                }
            }
            _DASP.data_changed.waveset.set_all(true);

            return error_text;
        }

        public string shape_harmonics(c_harmonic_level_shaping_action hlsa)
        {
            string error_text = "";

            double hdiff;
            double db_change;
            double level_change_perc;
            for (Int32 n = 0; n < max_note_sectors; n++)
            {
                for (Int32 w = 0; w <= 4; w++)
                {
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        if ((hlsa.direction == directions.up) && (h > hlsa.start_harmonic))
                        {
                            hdiff = h - hlsa.start_harmonic;
                            db_change = (hdiff / hlsa.start_harmonic) * DA_Spectral.get_dbchange_value(hlsa.db_per_octave);
                            level_change_perc = 1.0 + ((db_change / 10) * 0.5);
                            block[n, current_intensity_layer_id].waveform[w].scale_harmonic_level(h, level_change_perc);
                        }
                        else if ((hlsa.direction == directions.down) && (h < hlsa.start_harmonic))
                        {
                            hdiff = hlsa.start_harmonic - h;
                            db_change = (hdiff / hlsa.start_harmonic) * DA_Spectral.get_dbchange_value(hlsa.db_per_octave);
                            level_change_perc = 1.0 + ((db_change / 10) * 0.5);
                            block[n, current_intensity_layer_id].waveform[w].scale_harmonic_level(h, level_change_perc);
                        }
                    }
                }
            }

            return error_text;
        }

        public void create_associated_data_rows()
        {
            delete_associated_data_rows();//Ensure any existing rows are deleted

            _CGS.Table_waveform_set.GetRow(waveform_set_id).waveform_set_guid8 = BL_Spectral.GetNewGuid8();
            for (Int32 n = 0; n < max_note_sectors; n++)
            {
                for (Int32 l = 0; l < max_intensity_layers; l++)
                {
                    for (Int32 w = 0; w < max_waveforms; w++)
                    {
                        _CGS.Table_waveform.AddRow3(waveform_set_id, n, l, w, BL_DGV.default_text);

                        for (Int32 h = 0; h < max_harmonics; h++)
                        {
                            _CGS.Table_waveform_harmonic.AddRow3(waveform_set_id, n, l, w, h, 0, 0);
                        }
                    }
                }
            }
        }

        public void delete_associated_data_rows()
        {
            for (Int32 n = 0; n < max_note_sectors; n++)
            {
                for (Int32 l = 0; l < max_intensity_layers; l++)
                {
                    for (Int32 w = 0; w < max_waveforms; w++)
                    {
                        if (_CGS.Table_waveform.GetRow(waveform_set_id, n, l, w) != null)
                        {
                            for (Int32 h = 0; h < max_harmonics; h++)
                            {
                                _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, n, l, w, h).Delete();
                            }
                            _CGS.Table_waveform.GetRow(waveform_set_id, n, l, w).Delete();
                        }
                    }
                }
            }
        }

        public bool is_referred_to()
        {
            for (Int32 p = 0; p < _CGS.Table_patch.RowCount(); p++)
            {
                patchRow pr = (patchRow)_CGS.Table_patch.DT.Rows[p];
                if (pr.waveform_set_id == waveform_set_id)
                {
                    return true;
                }
            }
            return false;
        }
        #endregion

        #region "===================== METHODS 3D - Note Sector ================================="
        private double get_min_waveform_level_scaling_across_ns(int waveform_id)
        {
            double min_scaling = 10000;
            double scaling;

            for (int note_sector_id = 0; note_sector_id < DA_Spectral.max_note_sectors; note_sector_id++)
            {
                scaling = block[note_sector_id, _current_intensity_layer_id].waveform[waveform_id].CalcLevelScaling();
                if (scaling < min_scaling) { min_scaling = scaling; }
            }

            return min_scaling;
        }

        public void AddPolyLine3DWaveformsAcrossNS(ref DA_3DWireframe w, RectangleF rect, float dpi, Pen text_pen, Pen waveform_pen, Pen highlighted_waveform_pen, Pen interpolated_waveform_pen, Pen highlighted_interpolated_waveform_pen, bool flag_add_interpolated_waveforms)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;
            int waveform_id = current_block.current_waveform.waveform_id;
            double waveform_scaling = get_min_waveform_level_scaling_across_ns(waveform_id) * waveform_overall_scaling;

            for (int note_sector_id = 0; note_sector_id < DA_Spectral.max_note_sectors; note_sector_id++)
            {
                wp3d = block[note_sector_id, _current_intensity_layer_id].waveform[waveform_id].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling,note_sector_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((note_sector_id < (DA_Spectral.max_note_sectors - 1)) && (flag_add_interpolated_waveforms))
                {
                    //Add interpolated waveforms
                    wp3d_next = block[note_sector_id + 1, _current_intensity_layer_id].waveform[waveform_id].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling, note_sector_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_waveform_pen, highlighted_interpolated_waveform_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("NS4", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, 200), rect, dpi, text_pen);
            w.AddTextTo3DWorld("NS0", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, -200), rect, dpi, text_pen);
        }

        public void AddPolyLine3DHarmonicsAcrossNS(ref DA_3DWireframe w, RectangleF rect, float dpi, Pen text_pen, Pen harmonic_pen, Pen highlighted_harmonic_pen, Pen interpolated_harmonic_pen, Pen highlighted_interpolated_harmonic_pen, bool flag_add_interpolated_harmonics)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;
            int waveform_id = current_block.current_waveform.waveform_id;

            for (int note_sector_id = 0; note_sector_id < DA_Spectral.max_note_sectors; note_sector_id++)
            {
                wp3d = block[note_sector_id, _current_intensity_layer_id].waveform[waveform_id].get_3d_harmonic_polyline(harmonic_pen, highlighted_harmonic_pen,  note_sector_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((note_sector_id < (DA_Spectral.max_note_sectors - 1)) && (flag_add_interpolated_harmonics))
                {
                    //Add interpolated waveforms
                    wp3d_next = block[note_sector_id + 1, _current_intensity_layer_id].waveform[waveform_id].get_3d_harmonic_polyline(harmonic_pen, highlighted_harmonic_pen, note_sector_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_harmonic_pen, highlighted_interpolated_harmonic_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("NS4", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, 200), rect, dpi, text_pen);
            w.AddTextTo3DWorld("NS0", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, -200), rect, dpi, text_pen);
        }

        #endregion

        #region "===================== METHODS 3D - Intensity Layer ================================="
        private double get_min_waveform_level_scaling_across_il(int waveform_id)
        {
            double min_scaling = 10000;
            double scaling;

            for (int intensity_layer_id = 0; intensity_layer_id < DA_Spectral.max_intensity_layers; intensity_layer_id++)
            {
                scaling = block[_current_note_sector_id, intensity_layer_id].waveform[waveform_id].CalcLevelScaling();
                if (scaling < min_scaling) { min_scaling = scaling; }
            }

            return min_scaling;
        }

        public void AddPolyLine3DWaveformsAcrossIL(ref DA_3DWireframe w, RectangleF rect, float dpi, Pen text_pen, Pen waveform_pen, Pen highlighted_waveform_pen, Pen interpolated_waveform_pen, Pen highlighted_interpolated_waveform_pen, bool flag_add_interpolated_waveforms)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;
            int waveform_id = current_block.current_waveform.waveform_id;
            double waveform_scaling = get_min_waveform_level_scaling_across_il(waveform_id) * waveform_overall_scaling;

            for (int intensity_layer_id = 0; intensity_layer_id < DA_Spectral.max_intensity_layers; intensity_layer_id++)
            {
                wp3d = block[_current_note_sector_id, intensity_layer_id].waveform[waveform_id].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling, intensity_layer_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((intensity_layer_id < (DA_Spectral.max_intensity_layers - 1)) && (flag_add_interpolated_waveforms))
                {
                    //Add interpolated waveforms
                    wp3d_next = block[_current_note_sector_id, intensity_layer_id + 1].waveform[waveform_id].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling, intensity_layer_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_waveform_pen, highlighted_interpolated_waveform_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("IL2", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, 40), rect, dpi, text_pen);
            w.AddTextTo3DWorld("IL0", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, -200), rect, dpi, text_pen);

        }

        public void AddPolyLine3DHarmonicsAcrossIL(ref DA_3DWireframe w, RectangleF rect, float dpi, Pen text_pen, Pen harmonic_pen, Pen highlighted_harmonic_pen, Pen interpolated_harmonic_pen, Pen highlighted_interpolated_harmonic_pen, bool flag_add_interpolated_harmonics)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;
            int waveform_id = current_block.current_waveform.waveform_id;
            
            for (int intensity_layer_id = 0; intensity_layer_id < DA_Spectral.max_intensity_layers; intensity_layer_id++)
            {
                wp3d = block[_current_note_sector_id, intensity_layer_id].waveform[waveform_id].get_3d_harmonic_polyline(harmonic_pen, highlighted_harmonic_pen, intensity_layer_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((intensity_layer_id < (DA_Spectral.max_intensity_layers - 1)) && (flag_add_interpolated_harmonics))
                {
                    //Add interpolated waveforms
                    wp3d_next = block[_current_note_sector_id, intensity_layer_id + 1].waveform[waveform_id].get_3d_harmonic_polyline(harmonic_pen, highlighted_harmonic_pen, intensity_layer_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_harmonic_pen, highlighted_interpolated_harmonic_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("IL2", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, 40), rect, dpi, text_pen);
            w.AddTextTo3DWorld("IL0", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, -200), rect, dpi, text_pen);
        }

        #endregion
    }
}
